<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:template name="Table-CellWidths">
  <xsl:param name="ParamTable" />

  <!-- Locate first table cell -->
  <!--                         -->
  <xsl:variable name="VarSectionTableCells" select="$ParamTable/wwdoc:TableHead[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1] | $ParamTable/wwdoc:TableBody[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1] | $ParamTable/wwdoc:TableFoot[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1]" />
  <xsl:for-each select="$VarSectionTableCells[1]">
   <xsl:variable name="VarFirstTableCell" select="." />

   <!-- Determine cell widths -->
   <!--                       -->
   <xsl:call-template name="Table-RecursiveCellWidths">
    <xsl:with-param name="ParamTable" select="$ParamTable" />
    <xsl:with-param name="ParamTableCell" select="$VarFirstTableCell" />
    <xsl:with-param name="ParamTableCellColumnStartIndex" select="1" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Table-RecursiveCellWidths">
  <xsl:param name="ParamTable" />
  <xsl:param name="ParamTableCell" />
  <xsl:param name="ParamTableCellColumnStartIndex" />

  <!-- Calculate column span -->
  <!--                       -->
  <xsl:variable name="VarColumnSpan">
   <xsl:variable name="VarColumnSpanHint" select="$ParamTableCell/wwdoc:Style/wwdoc:Attribute[@name = 'column-span']/@value" />
   <xsl:choose>
    <xsl:when test="string-length($VarColumnSpanHint) &gt; 0">
     <xsl:value-of select="$VarColumnSpanHint" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="1" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- End column index -->
  <!--                  -->
  <xsl:variable name="VarTableCellColumnEndIndex" select="$ParamTableCellColumnStartIndex + $VarColumnSpan - 1" />

  <!-- Determine width of column span -->
  <!--                                -->
  <xsl:variable name="VarCellWidth">
   <xsl:call-template name="Table-ColumnWidth">
    <xsl:with-param name="ParamTableColumn" select="$ParamTable/wwdoc:TableColumns/wwdoc:TableColumn[1]" />
    <xsl:with-param name="ParamTableColumnIndex" select="1" />
    <xsl:with-param name="ParamAccumulatedWidth" select="'0pt'" />
    <xsl:with-param name="ParamTableColumnStartIndex" select="$ParamTableCellColumnStartIndex" />
    <xsl:with-param name="ParamTableColumnEndIndex" select="$VarTableCellColumnEndIndex" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Cell width -->
  <!--            -->
  <wwdoc:TableCellWidth id="{$ParamTableCell/@id}" width="{$VarCellWidth}" />

  <!-- Recurse -->
  <!--         -->
  <xsl:for-each select="$ParamTableCell/following-sibling::wwdoc:TableCell[1]">
   <xsl:variable name="VarNextTableCell" select="." />

   <xsl:call-template name="Table-RecursiveCellWidths">
    <xsl:with-param name="ParamTable" select="$ParamTable" />
    <xsl:with-param name="ParamTableCell" select="$VarNextTableCell" />
    <xsl:with-param name="ParamTableCellColumnStartIndex" select="$VarTableCellColumnEndIndex + 1" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Table-ColumnWidth">
  <xsl:param name="ParamTableColumn" />
  <xsl:param name="ParamTableColumnIndex" />
  <xsl:param name="ParamAccumulatedWidth" />
  <xsl:param name="ParamTableColumnStartIndex" />
  <xsl:param name="ParamTableColumnEndIndex" />

  <!-- Determine new accumulated width -->
  <!--                                 -->
  <xsl:variable name="VarAccumulatedWidth">
   <xsl:choose>
    <!-- Extend accumulated width -->
    <!--                          -->
    <xsl:when test="($ParamTableColumnIndex &gt;= $ParamTableColumnStartIndex) and ($ParamTableColumnIndex &lt;= $ParamTableColumnEndIndex)">
     <xsl:variable name="VarAccumulatedNumber" select="wwunits:NumericPrefix($ParamAccumulatedWidth)" />
     <xsl:variable name="VarAccumulatedUnits" select="wwunits:UnitsSuffix($ParamAccumulatedWidth)" />
     <xsl:variable name="VarColumnNumber" select="wwunits:NumericPrefix($ParamTableColumn/@width)" />
     <xsl:variable name="VarColumnUnits" select="wwunits:UnitsSuffix($ParamTableColumn/@width)" />

     <xsl:variable name="VarColumnNumberInAccumulatedUnits" select="wwunits:Convert($VarColumnNumber, $VarColumnUnits, $VarAccumulatedUnits)" />

     <!-- Result -->
     <!--        -->
     <xsl:value-of select="$VarAccumulatedNumber + $VarColumnNumberInAccumulatedUnits" />
     <xsl:value-of select="$VarAccumulatedUnits" />
    </xsl:when>

    <!-- Preserve current accumulated width as is -->
    <!--                                          -->
    <xsl:otherwise>
     <xsl:value-of select="$ParamAccumulatedWidth" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Emit result or keep accumulating column widths -->
  <!--                                                -->
  <xsl:choose>
   <xsl:when test="$ParamTableColumnIndex = $ParamTableColumnEndIndex">
    <xsl:value-of select="$VarAccumulatedWidth" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:call-template name="Table-ColumnWidth">
     <xsl:with-param name="ParamTableColumn" select="$ParamTableColumn/following-sibling::wwdoc:TableColumn[1]" />
     <xsl:with-param name="ParamTableColumnIndex" select="$ParamTableColumnIndex + 1" />
     <xsl:with-param name="ParamAccumulatedWidth" select="$VarAccumulatedWidth" />
     <xsl:with-param name="ParamTableColumnStartIndex" select="$ParamTableColumnStartIndex" />
     <xsl:with-param name="ParamTableColumnEndIndex" select="$ParamTableColumnEndIndex" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
